/*
 * Decompiled with CFR 0.152.
 */
package com.work4games.gamestate;

import com.work4games.entity.Button;
import com.work4games.entity.Mouse;
import com.work4games.entity.PlayerSave;
import com.work4games.gamestate.GameState;
import com.work4games.gamestate.GameStateManager;
import com.work4games.handlers.Content;
import com.work4games.handlers.Keys;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.ArrayList;

public class TimeAttackMenuState
extends GameState {
    private Mouse mouse;
    private ArrayList<Button> buttons;

    public TimeAttackMenuState(GameStateManager gsm) {
        this.gsm = gsm;
        this.init();
    }

    @Override
    public void init() {
        this.mouse = new Mouse();
        this.buttons = new ArrayList();
        PlayerSave.setMode(2);
        PlayerSave.setTimeLimit(0.0);
        Button b = new Button(14, "2 MINUTES", "Level", 180, 44, 213, 200, true);
        this.buttons.add(b);
        Button b1 = new Button(14, "5 MINUTES", "Level", 180, 44, 213, 250, true);
        this.buttons.add(b1);
        Button b2 = new Button(14, "10 MINUTES", "Level", 180, 44, 213, 300, true);
        this.buttons.add(b2);
        Button b3 = new Button(14, "BACK", 180, 44, 320, 400, true);
        this.buttons.add(b3);
    }

    @Override
    public void update() {
        this.handleInput();
        int i = 0;
        while (i < this.buttons.size()) {
            Button b = this.buttons.get(i);
            b.update();
            if (b.intersects(this.mouse)) {
                b.setHover(true);
                if (this.mouse.getClicked()) {
                    if (b.getTag() == "Level") {
                        if (b.getButtonID() == "2 MINUTES") {
                            PlayerSave.setTimeLimit(120.0);
                        } else if (b.getButtonID() == "5 MINUTES") {
                            PlayerSave.setTimeLimit(300.0);
                        } else if (b.getButtonID() == "10 MINUTES") {
                            PlayerSave.setTimeLimit(600.0);
                        }
                        PlayerSave.setMap("/Maps/TimeAttack/Sqaure.map");
                        this.gsm.setState(1);
                    } else if (b.getButtonID() == "BACK") {
                        this.gsm.setState(0);
                    }
                }
            } else {
                b.setHover(false);
            }
            ++i;
        }
    }

    @Override
    public void draw(Graphics2D g) {
        g.drawImage((Image)Content.TimeAttack, 320 - Content.TimeAttack.getWidth() / 2, 50, null);
        g.drawImage((Image)Content.TimeMenu, 330, 168, null);
        g.setColor(Color.WHITE);
        g.setFont(this.gsm.pixelFont14);
        int i = 0;
        while (i < this.buttons.size()) {
            Button b = this.buttons.get(i);
            b.draw(g);
            ++i;
        }
        g.setFont(this.gsm.pixelFont22);
        g.drawString("High Score : " + PlayerSave.getTAHighScore(1), 345, 205);
        g.drawString("High Score : " + PlayerSave.getTAHighScore(2), 345, 255);
        g.drawString("High Score : " + PlayerSave.getTAHighScore(3), 345, 305);
        this.mouse.draw(g);
    }

    @Override
    public void handleInput() {
        this.mouse.update();
        if (Keys.isKeyPressed(Keys.ESCAPE)) {
            this.gsm.setState(0);
        }
    }
}

